/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.processors;

import dev.compactmods.crafting.lib.reactivestreams.Subscriber;
import dev.compactmods.crafting.lib.reactivestreams.Subscription;
import dev.compactmods.crafting.lib.reactivex.rxjava3.annotations.Nullable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.util.AppendOnlyLinkedArrayList;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.util.NotificationLite;
import dev.compactmods.crafting.lib.reactivex.rxjava3.plugins.RxJavaPlugins;
import dev.compactmods.crafting.lib.reactivex.rxjava3.processors.FlowableProcessor;

final class SerializedProcessor<T>
extends FlowableProcessor<T> {
    final FlowableProcessor<T> actual;
    boolean emitting;
    AppendOnlyLinkedArrayList<Object> queue;
    volatile boolean done;

    SerializedProcessor(FlowableProcessor<T> actual) {
        this.actual = actual;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.actual.subscribe(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSubscribe(Subscription s) {
        boolean cancel;
        if (!this.done) {
            SerializedProcessor serializedProcessor = this;
            synchronized (serializedProcessor) {
                if (this.done) {
                    cancel = true;
                } else {
                    if (this.emitting) {
                        AppendOnlyLinkedArrayList<Object> q = this.queue;
                        if (q == null) {
                            this.queue = q = new AppendOnlyLinkedArrayList(4);
                        }
                        q.add(NotificationLite.subscription(s));
                        return;
                    }
                    this.emitting = true;
                    cancel = false;
                }
            }
        } else {
            cancel = true;
        }
        if (cancel) {
            s.cancel();
        } else {
            this.actual.onSubscribe(s);
            this.emitLoop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t) {
        if (this.done) {
            return;
        }
        SerializedProcessor serializedProcessor = this;
        synchronized (serializedProcessor) {
            if (this.done) {
                return;
            }
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q = this.queue;
                if (q == null) {
                    this.queue = q = new AppendOnlyLinkedArrayList(4);
                }
                q.add(NotificationLite.next(t));
                return;
            }
            this.emitting = true;
        }
        this.actual.onNext(t);
        this.emitLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t) {
        boolean reportError;
        if (this.done) {
            RxJavaPlugins.onError(t);
            return;
        }
        SerializedProcessor serializedProcessor = this;
        synchronized (serializedProcessor) {
            if (this.done) {
                reportError = true;
            } else {
                this.done = true;
                if (this.emitting) {
                    AppendOnlyLinkedArrayList<Object> q = this.queue;
                    if (q == null) {
                        this.queue = q = new AppendOnlyLinkedArrayList(4);
                    }
                    q.setFirst(NotificationLite.error(t));
                    return;
                }
                reportError = false;
                this.emitting = true;
            }
        }
        if (reportError) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.actual.onError(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        SerializedProcessor serializedProcessor = this;
        synchronized (serializedProcessor) {
            if (this.done) {
                return;
            }
            this.done = true;
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q = this.queue;
                if (q == null) {
                    this.queue = q = new AppendOnlyLinkedArrayList(4);
                }
                q.add(NotificationLite.complete());
                return;
            }
            this.emitting = true;
        }
        this.actual.onComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emitLoop() {
        while (true) {
            AppendOnlyLinkedArrayList<Object> q;
            SerializedProcessor serializedProcessor = this;
            synchronized (serializedProcessor) {
                q = this.queue;
                if (q == null) {
                    this.emitting = false;
                    return;
                }
                this.queue = null;
            }
            q.accept(this.actual);
        }
    }

    @Override
    public boolean hasSubscribers() {
        return this.actual.hasSubscribers();
    }

    @Override
    public boolean hasThrowable() {
        return this.actual.hasThrowable();
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        return this.actual.getThrowable();
    }

    @Override
    public boolean hasComplete() {
        return this.actual.hasComplete();
    }
}

